package com.caohuayu.infobox;

import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;

import android.content.ContentValues;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

public class EditActivity extends AppCompatActivity
implements  View.OnClickListener{
    // 当前记录ID，为0时表示新记录
    private long rowid = 0;
    //
    Button btnDelete,btnSave,btnReturn;
    EditText txtInfo;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_edit);
        // 确认记录ID
        Intent intent = getIntent();
        String s = intent.getStringExtra("rowid");
        if(s==null || s.length()==0) rowid=0;
        else rowid = Long.valueOf(s);
        // 控件初始化
        btnDelete = (Button)findViewById(R.id.btnDelete);
        btnSave = (Button)findViewById(R.id.btnSave);
        btnReturn = (Button)findViewById(R.id.btnReturn);
        txtInfo=(EditText)findViewById(R.id.txtInfo);
        btnDelete.setOnClickListener(this);
        btnSave.setOnClickListener(this);
        btnReturn.setOnClickListener(this);
        // 如果记录ID大于0则显示信息内容
        if(rowid>0){
            SQLiteDatabase db = openOrCreateDatabase(
                    "infobox.db",MODE_PRIVATE,null);
            String sql = "select info from infobox where rowid="+rowid+";";
            Cursor cur = db.rawQuery(sql,null);
            if(cur.getCount()>0){
                cur.moveToFirst();
                txtInfo.setText(cur.getString(0));
            }
            cur.close();
            db.close();
        }
    }

    @Override
    public void onClick(View v){
        int vid = v.getId();
        if(vid==R.id.btnDelete){
            // 删除记录
            delete();
        }else if(vid==R.id.btnSave){
            // 保存记录
            save();
        }else if (vid==R.id.btnReturn){
            // 返回
            finish();
        }
    }

    // 删除当前记录
    private void delete(){
        AlertDialog.Builder dlg = new AlertDialog.Builder(this);
        dlg.setTitle("删除信息");
        dlg.setMessage("真的要删除当前信息吗?");
        dlg.setCancelable(false);
        // 确认操作
        dlg.setPositiveButton("确定", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                SQLiteDatabase db = openOrCreateDatabase(
                        "infobox.db",MODE_PRIVATE,null);
                String sql = "delete from infobox where rowid="+rowid+";";
                db.execSQL(sql);
                db.close();
                txtInfo.setText("");
                Toast.makeText(EditActivity.this,
                        "信息已删除",Toast.LENGTH_SHORT).show();
                finish();
            }
        });
        // 取消操作
        dlg.setNegativeButton("取消", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                return;
            }
        });
        //
        dlg.show();
    }

    // 保存记录
    private void save(){
        String s = txtInfo.getText().toString().trim();
        if(s.length()==0){
            Toast.makeText(this,
                    "请输入内容",Toast.LENGTH_SHORT).show();
            return;
        }
        SQLiteDatabase db = openOrCreateDatabase(
                "infobox.db",MODE_PRIVATE,null);
        if(rowid<=0) {
            // 添加记录
            ContentValues values = new ContentValues();
            values.put("info", s);
            long newid = db.insert("infobox", null, values);
            if (newid > 0){
                // 读取新记录的rowid
                rowid = newid;
                //
                Toast.makeText(this,
                        "信息已保存", Toast.LENGTH_SHORT).show();
            }
            else
                Toast.makeText(this,
                        "信息保存失败", Toast.LENGTH_SHORT).show();
        }else{
            // 更新记录
            ContentValues values = new ContentValues();
            values.put("info", s);
            if(db.update("infobox",values,
                    "rowid="+rowid,null)>0)
                Toast.makeText(this, "信息已保存",
                        Toast.LENGTH_SHORT).show();
            else
                Toast.makeText(this, "信息保存失败",
                        Toast.LENGTH_SHORT).show();
        }
        db.close();
    }

}